/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced;

import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.world.DETemplatePools;
import com.barion.dungeons_enhanced.world.structure.DECastle;
import com.barion.dungeons_enhanced.world.structure.DEDeepCrypt;
import com.barion.dungeons_enhanced.world.structure.DEDesertTemple;
import com.barion.dungeons_enhanced.world.structure.DEDesertTomb;
import com.barion.dungeons_enhanced.world.structure.DEDruidCircle;
import com.barion.dungeons_enhanced.world.structure.DEEldersTemple;
import com.barion.dungeons_enhanced.world.structure.DEIcePit;
import com.barion.dungeons_enhanced.world.structure.DELargeDungeon;
import com.barion.dungeons_enhanced.world.structure.DEMonsterMaze;
import com.barion.dungeons_enhanced.world.structure.DEPillagerCamp;
import com.barion.dungeons_enhanced.world.structure.DEPirateShip;
import com.barion.dungeons_enhanced.world.structure.DETallWitchHut;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEFlyingStructure;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEGroundStructure;
import com.barion.dungeons_enhanced.world.structure.prefabs.DESwimmingStructure;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEUndergroundStructure;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEUnderwaterStructure;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import com.legacy.structure_gel.api.structure.ExtendedJigsawStructure;
import com.legacy.structure_gel.api.structure.GridStructurePlacement;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawCapability;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class DEStructures {
    public static final StructureRegistrar<ExtendedJigsawStructure> CASTLE = StructureRegistrar.jigsawBuilder((ResourceLocation)DEUtil.location("castle")).placement(() -> DEStructures.gridPlacement(69, 78).build(CASTLE)).addPiece(() -> DECastle.Piece::new).pushStructure((context, settings) -> DEStructures.extendedJigsawStructure(context, settings, DECastle.Capability.Instance, DETemplatePools.CASTLE, 1, (HeightProvider)ConstantHeight.f_161945_).onSurface().build()).dimensions(new ResourceKey[]{Level.f_46428_}).terrainAdjustment(TerrainAdjustment.BEARD_BOX).popStructure().build();
    public static final StructureRegistrar<ExtendedJigsawStructure> DEEP_CRYPT = StructureRegistrar.jigsawBuilder((ResourceLocation)DEUtil.location("deep_crypt")).placement(() -> DEStructures.gridPlacement(39, 67).build(DEEP_CRYPT)).addPiece(() -> DEDeepCrypt.Piece::new).pushStructure((context, settings) -> DEStructures.extendedJigsawStructure(context, settings, DEDeepCrypt.Capability.Instance, DETemplatePools.DEEP_CRYPT, 4, (HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158930_((int)16), (VerticalAnchor)VerticalAnchor.m_158930_((int)48))).build()).dimensions(new ResourceKey[]{Level.f_46428_}).generationStep(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).popStructure().build();
    public static final StructureRegistrar<DEDesertTemple> DESERT_TEMPLE = StructureRegistrar.builder((ResourceLocation)DEUtil.location("desert_temple"), () -> () -> DEDesertTemple.CODEC).placement(() -> DEStructures.gridPlacement(39, 86).build(DESERT_TEMPLE)).addPiece(() -> DEDesertTemple.Piece::new).pushStructure(DEDesertTemple::new).dimensions(new ResourceKey[]{Level.f_46428_}).popStructure().build();
    public static final StructureRegistrar<ExtendedJigsawStructure> DESERT_TOMB = StructureRegistrar.jigsawBuilder((ResourceLocation)DEUtil.location("desert_tomb")).placement(() -> DEStructures.gridPlacement(29, 65).allowedNearSpawn(true).build(DESERT_TOMB)).addPiece(() -> DEDesertTomb.Piece::new).pushStructure((context, settings) -> DEStructures.extendedJigsawStructure(context, settings, DEDesertTomb.Capability.INSTANCE, DETemplatePools.DESERT_TOMB, 5, (HeightProvider)ConstantHeight.f_161945_).onSurface().build()).dimensions(new ResourceKey[]{Level.f_46428_}).popStructure().build();
    public static final StructureRegistrar<ExtendedJigsawStructure> DRUID_CIRCLE = StructureRegistrar.jigsawBuilder((ResourceLocation)DEUtil.location("druid_circle")).placement(() -> DEStructures.gridPlacement(41, 68).allowedNearSpawn(true).build(DRUID_CIRCLE)).addPiece(() -> DEDruidCircle.Piece::new).pushStructure((context, settings) -> DEStructures.extendedJigsawStructure(context, settings, DEDruidCircle.Capability.INSTANCE, DETemplatePools.DRUID_CIRCLE, 1, (HeightProvider)ConstantHeight.f_161945_).onSurface().build()).dimensions(new ResourceKey[]{Level.f_46428_}).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().build();
    public static final StructureRegistrar<DEUndergroundStructure> DUNGEON_VARIANT = StructureRegistrar.builder((ResourceLocation)DEUtil.location("dungeon_variant"), () -> () -> DEUndergroundStructure.CODEC_DUNGEON_VARIANT).placement(() -> DEStructures.gridPlacement(19, 59).allowedNearSpawn(true).build(DUNGEON_VARIANT)).addPiece(() -> DEUndergroundStructure.Piece::new).pushStructure(DEUndergroundStructure::DungeonVariant).dimensions(new ResourceKey[]{Level.f_46428_}).generationStep(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).popStructure().build();
    public static final StructureRegistrar<DEEldersTemple> ELDERS_TEMPLE = StructureRegistrar.builder((ResourceLocation)DEUtil.location("elders_temple"), () -> () -> DEEldersTemple.CODEC).placement(() -> DEStructures.gridPlacement(24).build(ELDERS_TEMPLE)).addPiece(() -> DEEldersTemple.Piece::new).pushStructure(DEEldersTemple::new).dimensions(new ResourceKey[]{Level.f_46428_}).noSpawns(StructureSpawnOverride.BoundingBoxType.STRUCTURE, new MobCategory[]{MobCategory.UNDERGROUND_WATER_CREATURE, MobCategory.AXOLOTLS, MobCategory.WATER_AMBIENT, MobCategory.WATER_CREATURE}).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.STRUCTURE, DEStructures.spawns(DEStructures.spawn(EntityType.f_20455_, 1, 2, 4))).popStructure().build();
    public static final StructureRegistrar<DESwimmingStructure> FISHING_SHIP = StructureRegistrar.builder((ResourceLocation)DEUtil.location("fishing_ship"), () -> () -> DESwimmingStructure.CODEC_FISHING_SHIP).placement(() -> DEStructures.gridPlacement(48, 68).allowedNearSpawn(true).build(FISHING_SHIP)).addPiece(() -> DEGroundStructure.Piece::new).pushStructure(DESwimmingStructure::FishingShip).dimensions(new ResourceKey[]{Level.f_46428_}).popStructure().build();
    public static final StructureRegistrar<DEFlyingStructure> FLYING_DUTCHMAN = StructureRegistrar.builder((ResourceLocation)DEUtil.location("flying_dutchman"), () -> () -> DEFlyingStructure.CODEC_FLYING_DUTCHMAN).placement(() -> DEStructures.gridPlacement(134, 63).build(FLYING_DUTCHMAN)).addPiece(() -> DEFlyingStructure.Piece::new).pushStructure(DEFlyingStructure::FlyingDutchman).dimensions(new ResourceKey[]{Level.f_46428_}).popStructure().build();
    public static final StructureRegistrar<DEGroundStructure> HAY_STORAGE = StructureRegistrar.builder((ResourceLocation)DEUtil.location("hay_storage"), () -> () -> DEGroundStructure.CODEC_HAY_STORAGE).placement(() -> DEStructures.gridPlacement(23, 77).allowedNearSpawn(true).build(HAY_STORAGE)).addPiece(() -> DEGroundStructure.Piece::new).pushStructure(DEGroundStructure::HayStorage).dimensions(new ResourceKey[]{Level.f_46428_}).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().build();
    public static final StructureRegistrar<DEIcePit> ICE_PIT = StructureRegistrar.builder((ResourceLocation)DEUtil.location("ice_pit"), () -> () -> DEIcePit.CODEC).addPiece(() -> DEGroundStructure.Piece::new).placement(() -> DEStructures.gridPlacement(34, 77).build(ICE_PIT)).pushStructure(DEIcePit::new).dimensions(new ResourceKey[]{Level.f_46428_}).popStructure().build();
    public static final StructureRegistrar<DEGroundStructure> JUNGLE_MONUMENT = StructureRegistrar.builder((ResourceLocation)DEUtil.location("jungle_monument"), () -> () -> DEGroundStructure.CODEC_JUNGLE_MONUMENT).placement(() -> DEStructures.gridPlacement(46, 74).build(JUNGLE_MONUMENT)).addPiece(() -> DEGroundStructure.Piece::new).pushStructure(DEGroundStructure::JungleMonument).dimensions(new ResourceKey[]{Level.f_46428_}).popStructure().build();
    public static final StructureRegistrar<ExtendedJigsawStructure> LARGE_DUNGEON = StructureRegistrar.jigsawBuilder((ResourceLocation)DEUtil.location("large_dungeon")).placement(() -> DEStructures.gridPlacement(59, 56).allowedNearSpawn(true).build(LARGE_DUNGEON)).addPiece(() -> DELargeDungeon.Piece::new).pushStructure((context, settings) -> DEStructures.extendedJigsawStructure(context, settings, DELargeDungeon.Capability.INSTANCE, DETemplatePools.LARGE_DUNGEON, 5, (HeightProvider)DEStructures.height(-16)).onSurface().build()).dimensions(new ResourceKey[]{Level.f_46428_}).popStructure().build();
    public static final StructureRegistrar<DEGroundStructure> MINERS_HOUSE = StructureRegistrar.builder((ResourceLocation)DEUtil.location("miners_house"), () -> () -> DEGroundStructure.CODEC_MINERS_HOUSE).placement(() -> DEStructures.gridPlacement(24, 80).allowedNearSpawn(true).build(MINERS_HOUSE)).addPiece(() -> DEGroundStructure.Piece::new).pushStructure(DEGroundStructure::MinersHouse).dimensions(new ResourceKey[]{Level.f_46428_}).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().build();
    public static final StructureRegistrar<ExtendedJigsawStructure> MONSTER_MAZE = StructureRegistrar.jigsawBuilder((ResourceLocation)DEUtil.location("monster_maze")).placement(() -> DEStructures.gridPlacement(32, 52).build(MONSTER_MAZE)).addPiece(() -> DEMonsterMaze.Piece::new).pushStructure((context, settings) -> DEStructures.extendedJigsawStructure(context, settings, DEMonsterMaze.Capability.INSTANCE, DETemplatePools.MONSTER_MAZE, 12, (HeightProvider)DEStructures.height(-17)).onSurface().build()).dimensions(new ResourceKey[]{Level.f_46428_}).popStructure().build();
    public static final StructureRegistrar<DEGroundStructure> MUSHROOM_HOUSE = StructureRegistrar.builder((ResourceLocation)DEUtil.location("mushroom_house"), () -> () -> DEGroundStructure.CODEC_MUSHROOM_HOUSE).placement(() -> DEStructures.gridPlacement(19, 83).allowedNearSpawn(true).build(MUSHROOM_HOUSE)).addPiece(() -> DEGroundStructure.Piece::new).pushStructure(DEGroundStructure::MushroomHouse).dimensions(new ResourceKey[]{Level.f_46428_}).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().build();
    public static final StructureRegistrar<ExtendedJigsawStructure> PILLAGER_CAMP = StructureRegistrar.jigsawBuilder((ResourceLocation)DEUtil.location("pillager_camp")).placement(() -> DEStructures.gridPlacement(56, 39).build(PILLAGER_CAMP)).addPiece(() -> DEPillagerCamp.Piece::new).pushStructure((context, settings) -> DEStructures.extendedJigsawStructure(context, settings, DEPillagerCamp.Capability.INSTANCE, DETemplatePools.PILLAGER_CAMP, 4, (HeightProvider)ConstantHeight.f_161945_).onSurface().build()).dimensions(new ResourceKey[]{Level.f_46428_}).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.STRUCTURE, DEStructures.spawns(DEStructures.spawn(EntityType.f_20513_, 4, 2, 3), DEStructures.spawn(EntityType.f_20493_, 2, 1, 2))).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().build();
    public static final StructureRegistrar<DEPirateShip> PIRATE_SHIP = StructureRegistrar.builder((ResourceLocation)DEUtil.location("pirate_ship"), () -> () -> DEPirateShip.CODEC).placement(() -> DEStructures.gridPlacement(67, 49).build(PIRATE_SHIP)).addPiece(() -> DEGroundStructure.Piece::new).pushStructure(DEPirateShip::new).dimensions(new ResourceKey[]{Level.f_46428_}).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.STRUCTURE, DEStructures.spawns(DEStructures.spawn(EntityType.f_20513_, 4, 3, 4), DEStructures.spawn(EntityType.f_20493_, 3, 1, 2))).noSpawns(StructureSpawnOverride.BoundingBoxType.STRUCTURE, new MobCategory[]{MobCategory.UNDERGROUND_WATER_CREATURE, MobCategory.AXOLOTLS, MobCategory.WATER_AMBIENT, MobCategory.WATER_CREATURE}).popStructure().build();
    public static final StructureRegistrar<DEGroundStructure> RUINED_BUILDING = StructureRegistrar.builder((ResourceLocation)DEUtil.location("ruined_building"), () -> () -> DEGroundStructure.CODEC_RUINED_BUILDING).placement(() -> DEStructures.gridPlacement(27, 54).allowedNearSpawn(true).build(RUINED_BUILDING)).addPiece(() -> DEGroundStructure.Piece::new).pushStructure(DEGroundStructure::RuinedBuilding).dimensions(new ResourceKey[]{Level.f_46428_}).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().build();
    public static final StructureRegistrar<DEGroundStructure> STABLES = StructureRegistrar.builder((ResourceLocation)DEUtil.location("stables"), () -> () -> DEGroundStructure.CODEC_STABLES).placement(() -> DEStructures.gridPlacement(53, 52).allowedNearSpawn(true).build(STABLES)).addPiece(() -> DEGroundStructure.Piece::new).pushStructure(DEGroundStructure::Stables).dimensions(new ResourceKey[]{Level.f_46428_}).popStructure().build();
    public static final StructureRegistrar<DEUnderwaterStructure> SUNKEN_SHRINE = StructureRegistrar.builder((ResourceLocation)DEUtil.location("sunken_shrine"), () -> () -> DEUnderwaterStructure.CODEC_SUNKEN_SHRINE).placement(() -> DEStructures.gridPlacement(32, 55).allowedNearSpawn(true).build(SUNKEN_SHRINE)).addPiece(() -> DEUnderwaterStructure.Piece::new).pushStructure(DEUnderwaterStructure::SunkenShrine).dimensions(new ResourceKey[]{Level.f_46428_}).popStructure().build();
    public static final StructureRegistrar<DETallWitchHut> TALL_WITCH_HUT = StructureRegistrar.builder((ResourceLocation)DEUtil.location("tall_witch_hut"), () -> () -> DETallWitchHut.CODEC).placement(() -> DEStructures.gridPlacement(21, 61).allowedNearSpawn(true).build(TALL_WITCH_HUT)).addPiece(() -> DEGroundStructure.Piece::new).pushStructure(DETallWitchHut::new).dimensions(new ResourceKey[]{Level.f_46428_}).popStructure().build();
    public static final StructureRegistrar<DEGroundStructure> TREE_HOUSE;
    public static final StructureRegistrar<DEGroundStructure> TOWER_OF_THE_UNDEAD;
    public static final StructureRegistrar<DEGroundStructure> WATCH_TOWER;
    public static final StructureRegistrar<DEGroundStructure> WITCH_TOWER;
    public static final StructureRegistrar<?>[] ALL_STRUCTURE_REGISTRARS;

    private DEStructures() {
    }

    private static ConstantHeight height(int y) {
        return ConstantHeight.m_161956_((VerticalAnchor)new VerticalAnchor.Absolute(y));
    }

    private static Supplier<List<MobSpawnSettings.SpawnerData>> spawns(MobSpawnSettings.SpawnerData ... spawns) {
        return () -> Arrays.stream(spawns).toList();
    }

    private static MobSpawnSettings.SpawnerData spawn(EntityType<?> entity, int weight, int min, int max) {
        return new MobSpawnSettings.SpawnerData(entity, weight, min, max);
    }

    private static GridStructurePlacement.Builder gridPlacement(int spacing, int probability) {
        return DEStructures.gridPlacement(spacing).probability((float)probability / 100.0f);
    }

    private static GridStructurePlacement.Builder gridPlacement(int spacing) {
        return GridStructurePlacement.builder().spacing(spacing).offset((int)((double)spacing * 0.8));
    }

    private static ExtendedJigsawStructure.Builder extendedJigsawStructure(BootstapContext<?> context, Structure.StructureSettings settings, JigsawCapability.IJigsawCapability capability, ResourceKey<StructureTemplatePool> poolKey, int maxDepth, HeightProvider heightProvider) {
        return ExtendedJigsawStructure.builder((Structure.StructureSettings)settings, (Holder)context.m_255420_(Registries.f_256948_).m_255043_(poolKey)).maxDepth(maxDepth).startHeight(heightProvider).capability(capability);
    }

    static {
        TOWER_OF_THE_UNDEAD = StructureRegistrar.builder((ResourceLocation)DEUtil.location("tower_of_the_undead"), () -> () -> DEGroundStructure.CODEC_TOWER_OF_THE_UNDEAD).placement(() -> DEStructures.gridPlacement(49, 65).allowedNearSpawn(true).build(TOWER_OF_THE_UNDEAD)).addPiece(() -> DEGroundStructure.Piece::new).pushStructure(DEGroundStructure::TowerOfTheUndead).dimensions(new ResourceKey[]{Level.f_46428_}).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().build();
        TREE_HOUSE = StructureRegistrar.builder((ResourceLocation)DEUtil.location("tree_house"), () -> () -> DEGroundStructure.CODEC_TREE_HOUSE).placement(() -> DEStructures.gridPlacement(29, 40).allowedNearSpawn(true).build(TREE_HOUSE)).addPiece(() -> DEGroundStructure.Piece::new).pushStructure(DEGroundStructure::TreeHouse).dimensions(new ResourceKey[]{Level.f_46428_}).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().build();
        WATCH_TOWER = StructureRegistrar.builder((ResourceLocation)DEUtil.location("watch_tower"), () -> () -> DEGroundStructure.CODEC_WATCH_TOWER).placement(() -> DEStructures.gridPlacement(27, 45).allowedNearSpawn(true).build(WATCH_TOWER)).addPiece(() -> DEGroundStructure.Piece::new).pushStructure(DEGroundStructure::WatchTower).dimensions(new ResourceKey[]{Level.f_46428_}).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().build();
        WITCH_TOWER = StructureRegistrar.builder((ResourceLocation)DEUtil.location("witch_tower"), () -> () -> DEGroundStructure.CODEC_WITCH_TOWER).placement(() -> DEStructures.gridPlacement(79, 54).allowedNearSpawn(true).build(WITCH_TOWER)).addPiece(() -> DEGroundStructure.Piece::new).pushStructure(DEGroundStructure::WitchTower).dimensions(new ResourceKey[]{Level.f_46428_}).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().build();
        ALL_STRUCTURE_REGISTRARS = new StructureRegistrar[]{CASTLE, DEEP_CRYPT, DESERT_TEMPLE, DESERT_TOMB, DRUID_CIRCLE, DUNGEON_VARIANT, ELDERS_TEMPLE, FISHING_SHIP, FLYING_DUTCHMAN, HAY_STORAGE, ICE_PIT, JUNGLE_MONUMENT, LARGE_DUNGEON, MINERS_HOUSE, MONSTER_MAZE, MUSHROOM_HOUSE, PILLAGER_CAMP, PIRATE_SHIP, RUINED_BUILDING, STABLES, SUNKEN_SHRINE, TALL_WITCH_HUT, TOWER_OF_THE_UNDEAD, TREE_HOUSE, WATCH_TOWER, WITCH_TOWER};
    }
}

